<?php

namespace Suiterus\Dms\Models\Files;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Suiterus\Dms\Models\Files\FileVersion;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class FileComment extends Model
{
    use HasFactory,
        SoftDeletes;

    protected $connection = 'dms_db';

    protected $fillable = [
        'file_version_id',
        'body',
        'created_by',
    ];

    protected $with = [
        'user',
    ];

    public function user()
    {
        return $this->belongsTo('App\Models\User', 'created_by', 'id')->without([
            'roles',
            'permissions',
            'storage',
            'employeeMetaInfo',
            'supervisor',
            'exitInterview',
            'profileBasicInfo'
        ]);
    }

    public function versions()
    {
        return $this->belongsTo(FileVersion::class, 'file_version_id', 'id')->without([
            'user',
            'comment',
            'forward',
            'customFormValue'
        ]);
    }
}
