<?php

namespace Suiterus\Dms\Models\Files;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\AccessManagement\GroupManagement\Role;

class FileAccess extends Model
{
    use HasFactory;

    public function __construct(array $attributes = [])
    {
        $this->table = env('DMS_DB_DATABASE') . '.file_accesses';
        parent::__construct($attributes);
    }

    protected $fillable = [
        'user_id',
        'file_id',
        'group_id',
        'access_level',
        'shared_by',
        'shared_date'
    ];

    protected $with = [
        'user',
        'group',
        'sharedBy'
    ];

    protected $casts = [
        'shared_date' => 'date:M d, Y'
    ];

    public function file()
    {
        return $this->belongsTo('Suiterus\Dms\Models\Files\File');
    }

    public function user()
    {
        return $this->belongsTo('App\Models\User')->without([
            'roles',
            'permissions',
            'storage',
            'employeeMetaInfo',
            'supervisor',
            'exitInterview',
            'userProfilePicture',
            'profileBasicInfo'
        ]);
    }

    public function sharedBy()
    {
        return $this->belongsTo('App\Models\User', 'shared_by', 'id')->without([
            'roles',
            'permissions',
            'storage',
            'employeeMetaInfo',
            'supervisor',
            'exitInterview',
            'userProfilePicture',
            'profileBasicInfo'
        ]);
    }

    public function group()
    {
        return $this->belongsTo(Role::class, 'group_id', 'id')->with([
            'roleHasSystem' => function ($query) {
                $query->without(['role']);
            }
        ])->without([
            'roleLeader',
            'sectionAccess',
            'member'
        ]);
    }
}
