<?php

namespace Suiterus\Dms\Models\Files;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Suiterus\Dms\Models\Configuration\DocumentType;
use Suiterus\Dms\Models\Files\FileVersion;
use Suiterus\Dms\Models\OtherAttachments\OtherAttachments;

class File extends Model
{
    use HasFactory,
        SoftDeletes;

    protected $connection = 'dms_db';

    public function __construct(array $attributes = [])
    {
        $this->table = env('DMS_DB_DATABASE') . '.files';
        parent::__construct($attributes);
    }


    protected $fillable = [
        'section_id',
        'user_id',
        'name',
        'type',
        'privacy',
        'document_type',
        'modified_by',
        'effectivity',
        'expiry',
        'status',
        'deleted_by'
    ];

    protected $with = [
        'author',
        'modifier',
        'extraFields',
        'access',
        'versions',
        'documentType'
    ];

    public function section()
    {
        return $this->belongsTo('Suiterus\Dms\Models\Repositories\Section', 'section_id', 'id');
    }

    public function author()
    {
        return $this->belongsTo('App\Models\User', 'user_id', 'id')->select('id', 'name')->without(['roles', 'permissions', 'storage']);
    }

    public function modifier()
    {
        return $this->belongsTo('App\Models\User', 'modified_by', 'id')->select('id', 'name')->without(['roles', 'permissions', 'storage']);
    }

    public function access()
    {
        return $this->hasMany('Suiterus\Dms\Models\Files\FileAccess');
    }

    public function sharedBy()
    {
        $authUserRoles = Auth::user()->roles->pluck('id');
        return $this->hasOne('Suiterus\Dms\Models\Files\FileAccess')->where('user_id', Auth::id())->orWhereIn('group_id', $authUserRoles);
    }

    public function extraFields()
    {
        return $this->hasMany('Suiterus\Dms\Models\Files\FileField');
    }

    public function versions()
    {
        return $this->hasMany('Suiterus\Dms\Models\Files\FileVersion')->orderBy('file_version', 'desc');
    }

    public function otherAttachments()
    {
        return $this->hasMany(OtherAttachments::class, 'file_id', 'id');
    }

    public function documentType()
    {
        return $this->belongsTo(DocumentType::class, 'document_type', 'id');
    }

    public function latestVersion()
    {
        return $this->hasOne(FileVersion::class)->orderBy('file_version', 'desc');
    }

    public function deletedBy()
    {
        return $this->belongsTo('App\Models\User', 'deleted_by', 'id')->select('id', 'name')->without(['roles', 'permissions', 'storage']);
    }
    public function forward()
    {
        return $this->hasMany('Suiterus\Dms\Models\Files\Forward');
    }
}
