<?php

namespace Suiterus\Dms\Models\CustomForm;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CustomFormValue extends Model
{
    use HasFactory;

    protected $fillable = [
        'custom_form_id',
        'file_version_id',
        'form_value'
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('DMS_DB_DATABASE') . '.custom_form_values';
        $this->connection = env('DMS_DB_CONNECTION');
        parent::__construct($attributes);
    }

    public function customForm()
    {
        return $this->belongsTo(CustomForm::class, 'custom_form_id', 'id');
    }
}
