<?php

namespace Suiterus\Dms\Models\CustomForm;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Suiterus\Dms\Models\Configuration\DocumentType;

class CustomForm extends Model
{
    use HasFactory;

    protected $fillable = [
        'document_type_id',
        'form'
    ];

    protected $with = [
        'documentType'
    ];

    public function __construct(array $attributes = []){
        $this->table = env('DMS_DB_DATABASE') . '.custom_forms';
        $this->connection = env('DMS_DB_CONNECTION');
        parent::__construct($attributes);
    }

    public function documentType(){
        return $this->belongsTo(DocumentType::class, 'document_type_id', 'id');
    }

}
