<?php

namespace Suiterus\Dms\Models\Configuration;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Suiterus\Dms\Models\CustomForm\CustomForm;

class DocumentType extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'dms_db';

    protected $fillable = [
        'name',
        'status'
    ];

    protected $appends = [
        'formatted_custom_form'
    ];

    public function customForm(){
        return $this->hasOne(CustomForm::class, 'document_type_id', 'id')->without(['documentType']);
    }

    public function getFormattedCustomFormAttribute(){
        if ($this->customForm()->first()) {
            return json_decode($this->customForm()->first()->form);
        }
        return;
    }
}
