<?php

namespace Suiterus\Dms\Models\Configuration;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\Encryptable;

class ConfigEmail extends Model
{
    use HasFactory, Encryptable;

    protected $fillable = [
        'host_name',
        'smtp_auth',
        'email',
        'password',
        'mailer',
        'smtp_secure',
        'port',
        'mail_from_name',
        'notification_status',
        'created_by',
        'updated_by'
    ];

    protected $encryptable = [
        'host_name',
        'smtp_auth',
        'email',
        'mailer',
        'smtp_secure',
        'port',
        'mail_from_name'
    ];

    protected $hidden = [
        'password'
    ];

    public function __construct(array $attributes = []){
        $this->table = env('DMS_DB_DATABASE') . '.config_email';
        $this->connection = env('DMS_DB_CONNECTION');
        parent::__construct($attributes);
    }


}