<?php

namespace Suiterus\Dms\Models\Approvals;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Suiterus\Dms\Models\LevelOfApprover\LevelOfApprover;

class UserApprover extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'file_approver_id',
        'level_of_approver_id',
        'remark_type_id',
        'remark_description',
        'status',
    ];

    protected $appends = [
        'custom_form'
    ];

    protected $with = [
        'levelOfApprover'
    ];

    public function __construct(array $attributes = []){
        $this->table = env('DMS_DB_DATABASE') . '.user_approvers';
        $this->connection = env('DMS_DB_CONNECTION');
        parent::__construct($attributes);
    }

    public function user(){
        return $this->belongsTo(User::class, 'user_id', 'id')->select('id', 'name');
    }

    public function remark(){
        return $this->belongsTo(RemarkType::class, 'remark_type_id', 'id');
    }

    public function fileApprover(){
        return $this->belongsTo(FileApprover::class, 'file_approver_id', 'id');
    }

    public function levelOfApprover()
    {
        return $this->belongsTo(LevelOfApprover::class, 'level_of_approver_id', 'id')->withTrashed();
    }

    public function getCustomFormAttribute(){
        if ($this->fileApprover->approval->file->customFormValue) {
            return json_decode($this->fileApprover->approval->file->customFormValue->form_value);
        }
        return;
    }
}
