<?php

namespace Suiterus\Dms\Models\Approvals;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FileApprover extends Model
{
    use HasFactory;

    protected $fillable = [
        'approval_id',
        'role_id',
        'sequence',
        'is_approving',
        'approve',
        'reject',
        'status'
    ];

    public function __construct(array $attributes = []){
        $this->table = env('DMS_DB_DATABASE') . '.file_approvers';
        $this->connection = env('DMS_DB_CONNECTION');
        parent::__construct($attributes);
    }

    public function approval(){
        return $this->belongsTo(Approval::class, 'approval_id', 'id');
    }

    public function userApprover(){
        return $this->hasMany(UserApprover::class, 'file_approver_id', 'id');
    }
}
