<?php

namespace Suiterus\Dms\Models\Approvals;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Suiterus\Dms\Models\Configuration\DocumentType;
use Suiterus\Dms\Models\Files\File;
use Suiterus\Dms\Models\Files\FileVersion;

class Approval extends Model
{
    use HasFactory;

    protected $fillable = [
        'file_version_id',
        'user_id',
        'subject',
        'message',
        'status',
        'is_obsolete',
    ];

    protected $with = [
        'user'
    ];

    public function __construct(array $attributes = []){
        $this->table = env('DMS_DB_DATABASE') . '.approvals';
        $this->connection = env('DMS_DB_CONNECTION');
        parent::__construct($attributes);
    }

    public function user(){
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function fileApprover(){
        return $this->hasMany(FileApprover::class, 'approval_id', 'id');
    }

    public function file(){
        return $this->belongsTo(FileVersion::class, 'file_version_id', 'id')->withTrashed()->with(['file' => function($query) {
            $query->withTrashed();
        }]);
    }
}
