<?php

namespace Suiterus\Dms\Models\ApprovalTemplate;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserHasAdminTemplate extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'admin_approval_template_id',
    ];

    protected $with = [
        'user',
        'approvalTemplate'
    ];


    public function __construct(array $attributes = [])
    {
        $this->table = env('DMS_DB_DATABASE') . '.user_has_admin_templates';
        $this->connection = env('DMS_DB_CONNECTION');
        parent::__construct($attributes);
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id')->without([
            'roles',
            'permissions',
            'storage',
            'employeeMetaInfo',
            'supervisor',
            'exitInterview',
            'userProfilePicture',
            'profileBasicInfo'
        ]);
    }

    public function approvalTemplate()
    {
        return $this->belongsTo(AdminApprovalTemplate::class, 'admin_approval_template_id', 'id');
    }
}
