<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class DropColumnDocumentTypeToAdminApprovalTemplates extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('DMS_DB_CONNECTION'))->table('admin_approval_templates', function (Blueprint $table) {
            $table->dropForeign('admin_approval_templates_document_type_id_foreign');
            $table->dropColumn(['document_type_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('DMS_DB_CONNECTION'))->table('admin_approval_templates', function (Blueprint $table) {
            $table->unsignedBigInteger('document_type_id')->after('user_id')->nullable();
            $table->foreign('document_type_id')->references('id')->on(env('DMS_DB_DATABASE').'.document_types');
        });
    }
}
