<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddRoleIdToForwards extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('DMS_DB_CONNECTION'))->table('forwards', function (Blueprint $table) {
            $table->unsignedBigInteger('user_Id')->nullable()->change();
            $table->unsignedBigInteger('file_id')->nullable()->change();
            $table->foreign('user_id')->references('id')->on(env('DB_DATABASE') . '.users');
            $table->foreign('file_id')->references('id')->on(env('DMS_DB_DATABASE') . '.files');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('DMS_DB_CONNECTION'))->table('forwards', function (Blueprint $table) {
            $table->dropForeign('forwards_user_id_foreign');
            $table->dropForeign('forwards_file_id_foreign');
        });
    }
}
