<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddSharedColumnsToSectionAccesses extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('DMS_DB_CONNECTION'))->table('section_accesses', function (Blueprint $table) {
            $table->unsignedBigInteger('shared_by')->nullable()->after('access_level');
            $table->timestamp('shared_date')->nullable()->after('shared_by');
            $table->foreign('shared_by')->references('id')->on(env('DB_DATABASE'). '.users');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('DMS_DB_CONNECTION'))->table('section_accesses', function (Blueprint $table) {
            $table->dropForeign('section_accesses_shared_by_foreign');
            $table->dropColumn('shared_by');
            $table->dropColumn('shared_date');
        });
    }
}
