<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddDeletedByInFilesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('dms_db')->table('files', function (Blueprint $table) {
            $table->unsignedBigInteger('deleted_by')->nullable()->after('expiry')->references('id')->on(env('DB_DATABASE').'.users');
        });
    }
    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('DMS_DB_CONNECTION'))->table('files', function (Blueprint $table) {
            $table->dropColumn('deleted_by');
        });
    }
}
