<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddDeletedAndCreatedByInSections extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('dms_db')->table('sections', function (Blueprint $table) {
            $table->unsignedBigInteger('created_by')->nullable()->after('status')->references('id')->on(env('DB_DATABASE').'.users');
            $table->unsignedBigInteger('deleted_by')->nullable()->after('created_by')->references('id')->on(env('DB_DATABASE').'.users');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('DMS_DB_CONNECTION'))->table('sections', function (Blueprint $table) {
            $table->dropColumn('created_by');
            $table->dropColumn('deleted_by');
        });
    }
}
