<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateGenerateDriveLinksTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('DMS_DB_CONNECTION'))->create('generate_drive_links', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('section_id');
            $table->string('generated_drive_link')->unique();
            $table->boolean('is_viewable')->default(1);
            $table->unsignedBigInteger('created_by');
            $table->foreign('section_id')->references('id')->on(env('DMS_DB_DATABASE') . '.sections')->onDelete('cascade');
            $table->foreign('created_by')->references('id')->on(env('DB_DATABASE') . '.users');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('DMS_DB_CONNECTION'))->dropIfExists('generate_drive_links');
    }
}
