<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnPrivacyToFiles extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('dms_db')->table('files', function (Blueprint $table) {
            $table->integer('privacy')->nullable()->after('type')->comment('1 = Confidential, 2 = Restricted');
            $table->integer('document_type')->nullable()->after('privacy')->references('id')->on(env('DMS_DB_DATABASE').'.document_types');;
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('DMS_DB_CONNECTION'))->table('files', function (Blueprint $table) {
            $table->dropColumn('privacy');
            $table->dropColumn('document_type');
        });
    }
}
