<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnLevelOfApproverIdToUserApprovers extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('DMS_DB_CONNECTION'))->table('user_approvers', function (Blueprint $table) {
            $table->unsignedBigInteger('level_of_approver_id')->after('file_approver_id')->nullable();
            $table->foreign('level_of_approver_id')->references('id')->on(env('DMS_DB_DATABASE').'.level_of_approvers');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('DMS_DB_CONNECTION'))->table('user_approvers', function (Blueprint $table) {
            $table->dropForeign('user_approvers_level_of_approver_id_foreign');
            $table->dropColumn('level_of_approver_id');
        });
    }
}
