<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddIsObsoleteToFileVersions extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('DMS_DB_CONNECTION'))->table('file_versions', function (Blueprint $table) {
            $table->integer('is_obsolete')->default(0)->comment(' 0 = active, 1 = obsolete');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('DMS_DB_CONNECTION'))->table('file_versions', function (Blueprint $table) {
            $table->dropColumn(['is_obsolete']);
        });
    }
}
