<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class DropIsObsoleteColummFromApprovals extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('DMS_DB_CONNECTION'))->table('approvals', function (Blueprint $table) {
            $table->dropColumn(['is_obsolete']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('DMS_DB_CONNECTION'))->table('approvals', function (Blueprint $table) {
            $table->integer('is_obsolete')->default(0)->comment(' 0 = Active, 1 = obsolete');
        });
    }
}
