<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateGenerateFileLinksTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('DMS_DB_CONNECTION'))->create('generate_file_links', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('file_id');
            $table->string('generated_file_link')->unique();
            $table->boolean('is_viewable')->default(1);
            $table->unsignedBigInteger('created_by');
            $table->timestamps();
            $table->foreign('file_id')->references('id')->on(env('DMS_DB_DATABASE').'.files')->onDelete('cascade');
            $table->foreign('created_by')->references('id')->on(env('DB_DATABASE').'.users');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('DMS_DB_CONNECTION'))->dropIfExists('generate_file_links');
    }
}
