<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFileSignatorySignaturesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('dms_db')->create('file_signatory_signatures', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('file_signatory_id')->unique();
            $table->text('document_encrypted_path');
            $table->text('document_signature_path');
            $table->foreign('file_signatory_id')->references('id')->on(env('DMS_DB_DATABASE').'.file_signatories');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('dms_db')->dropIfExists('file_signatory_signatures');
    }
}
