<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFileSignatorySigneesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('dms_db')->create('file_signatory_signees', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('file_signatory_id');
            $table->unsignedBigInteger('user_id');
            $table->json('option');
            $table->integer('sequence');
            $table->integer('status')->comment('1 = pending, 2 = in-progress, 3 = signed, 4 = declined');
            $table->foreign('file_signatory_id')->references('id')->on(env('DMS_DB_DATABASE').'.file_signatories');
            $table->foreign('user_id')->references('id')->on(env('DB_DATABASE').'.users');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('dms_db')->dropIfExists('file_signatory_signees');
    }
}
