<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFileSignatoriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('dms_db')->create('file_signatories', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('file_version_id');
            $table->boolean('is_any_order');
            $table->integer('status')->default(1)->comment('1 = in-progress, 2 = signed, 3 = declined');
            $table->foreign('user_id')->references('id')->on(env('DB_DATABASE').'.users');
            $table->foreign('file_version_id')->references('id')->on(env('DMS_DB_DATABASE').'.file_versions');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('dms_db')->dropIfExists('file_signatories');
    }
}
