<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class ModifyForeignKeyToApprovals extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('DMS_DB_CONNECTION'))->table('approvals', function (Blueprint $table) {
            $table->renameColumn('file_id', 'file_version_id');
            $table->dropForeign(['file_id']);
            $table->foreign('file_version_id')->references('id')->on(env('DMS_DB_DATABASE').'.file_versions');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('DMS_DB_CONNECTION'))->table('approvals', function (Blueprint $table) {
            $table->renameColumn('file_version_id', 'file_id');
            $table->dropForeign(['file_version_id']);
            $table->foreign('file_id')->references('id')->on(env('DMS_DB_DATABASE').'.files');
        });
    }
}
