<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCustomFormValuesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('DMS_DB_CONNECTION'))->create('custom_form_values', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('custom_form_id');
            $table->unsignedBigInteger('file_version_id');
            $table->json('values');
            $table->foreign('custom_form_id')->references('id')->on(env('DMS_DB_DATABASE').'.custom_forms');
            $table->foreign('file_version_id')->references('id')->on(env('DMS_DB_DATABASE').'.file_versions');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('DMS_DB_CONNECTION'))->dropIfExists('custom_form_values');
    }
}
