<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUserApproversTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('DMS_DB_CONNECTION'))->create('user_approvers', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('file_approver_id');
            $table->unsignedBigInteger('remark_type_id')->nullable();
            $table->string('remark_description')->nullable();
            $table->integer('status')->comment('1 = revise, 2 = approve, 3 = decline, 4 = review, 5 = in progress');
            $table->foreign('user_id')->references('id')->on(env('DB_DATABASE').'.users');
            $table->foreign('file_approver_id')->references('id')->on(env('DMS_DB_DATABASE').'.file_approvers');
            $table->foreign('remark_type_id')->references('id')->on(env('DMS_DB_DATABASE').'.remark_types');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('DMS_DB_CONNECTION'))->dropIfExists('user_approvers');
    }
}
