<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFileApproversTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('DMS_DB_CONNECTION'))->create('file_approvers', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('approval_id');
            $table->unsignedBigInteger('role_id')->nullable();
            $table->integer('sequence');
            $table->boolean('is_approving');
            $table->integer('approve')->comment('1 = move to next level, 2 = approve the request');
            $table->integer('reject')->comment('1 = return to previous level, 2 = cancel the request');
            $table->integer('status')->comment('1 = approve, 2 = decline, 3 = in progress');
            $table->foreign('approval_id')->references('id')->on(env('DMS_DB_DATABASE').'.approvals');
            $table->foreign('role_id')->references('id')->on(env('DB_DATABASE').'.roles');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('DMS_DB_CONNECTION'))->dropIfExists('file_approvers');
    }
}
