<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateApprovalsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('DMS_DB_CONNECTION'))->create('approvals', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('file_id');
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('document_type_id')->nullable();
            $table->string('subject');
            $table->longText('message')->nullable();
            $table->integer('status')->comment('1 = approved, 2 = declined, 3 = revised, 4 = for approval');
            $table->timestamps();
            $table->foreign('file_id')->references('id')->on(env('DMS_DB_DATABASE').'.files');
            $table->foreign('user_id')->references('id')->on(env('DB_DATABASE').'.users');
            $table->foreign('document_type_id')->references('id')->on(env('DMS_DB_DATABASE').'.document_types');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('DMS_DB_CONNECTION'))->dropIfExists('approvals');
    }
}
