<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnToFileTypes extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('DMS_DB_CONNECTION'))->table('file_types', function (Blueprint $table) {
            $table->string('unit_byte')->nullable()->after('file_ext');
            $table->bigInteger('value')->nullable()->after('unit_byte');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('DMS_DB_CONNECTION'))->table('file_types', function (Blueprint $table) {
            $table->dropColumn(['unit_byte', 'value']);
        });
    }
}
