<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnsToAllowedFileTypes extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('DMS_DB_CONNECTION'))->table('allowed_file_types', function (Blueprint $table) {
            $table->string('unit_byte')->after('file_type');
            $table->bigInteger('value')->after('unit_byte');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('DMS_DB_CONNECTION'))->table('allowed_file_types', function (Blueprint $table) {
            $table->dropColumn('unit_byte');
            $table->dropColumn('value');
        });
    }
}
