<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateConfigEmailTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('DMS_DB_CONNECTION'))->create('config_email', function (Blueprint $table) {
            $table->id();
            $table->string('host_name');
            $table->string('smtp_auth');
            $table->string('email');
            $table->string('password');
            $table->string('mailer');
            $table->string('smtp_secure');
            $table->string('port');
            $table->integer('notification_status')->comment('0 = off, 1 = on');
            $table->integer('created_by');
            $table->integer('updated_by');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('DMS_DB_CONNECTION'))->dropIfExists('config_email');
    }
}
