<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateForwardsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('dms_db')->create('forwards', function (Blueprint $table) {
            $table->id();
            $table->integer('file_id')->unsigned();
            $table->integer('user_id')->unsigned();
            $table->string('subject');
            $table->string('message');
            $table->integer('status')->nullable()->comment('1 = viewed, 2 = received');
            $table->integer('created_by');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('forwards');
    }
}
