<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFileAccessesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('dms_db')->create('file_accesses', function (Blueprint $table) {
            $table->id();
            $table->integer('file_id')->unsigned();
            $table->integer('user_id')->nullable();
            $table->integer('group_id')->nullable();
            $table->integer('access_level')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('file_accesses');
    }
}
