<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFilesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('dms_db')->create('files', function (Blueprint $table) {
            $table->id();
            $table->integer('section_id')->default(0);
            $table->integer('user_id')->unsigned();
            $table->string('name');
            $table->integer('type')->default(1);
            $table->integer('modified_by')->unsigned();
            $table->timestamp('effectivity')->nullable();
            $table->timestamp('expiry')->nullable();
            $table->softDeletes();
            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('files');
    }
}
