<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateStoragesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('dms_db')->create('storages', function (Blueprint $table) {
            $table->id();
            $table->integer('user_id')->unsigned();
            $table->double('allocated',15,2)->default('5000.00');
            $table->double('consumed',15,2)->default('0.00');
            $table->string('type')->default('BASIC');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('storages');
    }
}
