<?php
namespace Suiterus\Dms\Imports;
use App\Enums\Status;
use App\Enums\Dms\DriveType;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Suiterus\Dms\Models\Repositories\Section;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Suiterus\Dms\Models\Repositories\SectionAccess;
class FolderImport implements ToCollection, WithHeadingRow
{
    public function collection(Collection $rows)
    {
        foreach ($rows as $row) {
            $this->createFolderStructure($row['folder_structure']);
        }
    }
    private function createFolderStructure($folderPath)
    {
        $folders = explode('/', $folderPath); 
        $parentSection = null;
        $developer = 2;
        foreach ($folders as $folderName) {
            $parentSection = Section::firstOrCreate(
                [
                    'name' => trim($folderName),
                    'parent_id' => $parentSection ? $parentSection->id : 0, 
                ],
                [
                    'description' => 'Folder description', 
                    'type' => DriveType::PRIVATE, 
                    'status' => Status::ACTIVE,
                    'created_by' => $developer,
                ]
            );
            SectionAccess::updateOrCreate(
                [
                    'section_id' => $parentSection->id, 
                    'user_id' => $developer
                ],
                [
                    'access_level' => 1, 
                    'created_at' => now(), 
                    'updated_at' => now()
                ]
            );
        }
    }
}

