<?php

namespace Suiterus\Dms\Imports;

use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\Importable;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithChunkReading;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use Maatwebsite\Excel\Concerns\WithColumnLimit;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithMapping;
use PhpOffice\PhpSpreadsheet\Shared\Date;

class ContractsImport implements ToCollection, WithHeadingRow, WithColumnLimit, WithMapping, WithChunkReading
{
    use Importable;
    /**
     * @param Collection $collection
     */
    public function collection(Collection $row)
    {
        //
    }

    public function endColumn(): string
    {
        return 'j'; // last column in excel file
    }

    public function map($row): array
    {
        return [
            'contract_no' => $row['contract_no'],
            'title' => $row['title'],
            'supplier' => $row['supplier'],
            'enduser' => $row['enduser'],
            'effectivity_date' => Date::excelToDateTimeObject($row['effectivity_date'])->format('Y-m-d'),
            'end_of_contract' => Date::excelToDateTimeObject($row['end_of_contract'])->format('Y-m-d'),
            'category' => $row['category'],
            'subcategory' => $row['subcategory'],
            'remarks' => $row['remarks'],
            'filename' => $row['filename']
        ];
    }

    public function chunkSize(): int
    {
        return 1000;
    }

}