<?php

namespace Suiterus\Dms\Helper;

use Suiterus\Dms\Models\Files\FileType;

class AllowedMimeType
{
    /**
     * The function getAllowedMimeType retrieves all enabled file types and their corresponding mime
     * types, concatenates them into a string, and appends the default mime type
     * "application/octet-stream".
     *
     * @return String a string that contains a list of allowed MIME types.
     */
    public static function getAllowedMimeTypes(): String
    {
        $allowedTypes = '';
        $enable = 1;
        $fileTypes = FileType::where([
            ['status', $enable],
            ['mime_type', '!=', null]
        ])->get();
        $concatenatedMime = [];
        foreach ($fileTypes as $fileType) {
            foreach ($fileType['mime_type'] as $mimeType) {
                if (!in_array($mimeType, $concatenatedMime)) {
                    $allowedTypes .= $mimeType . ',';
                    $concatenatedMime[] = $mimeType;
                }
            }
        }

        return $allowedTypes;
    }
}
