<?php

namespace Suiterus\Dms\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithStyles;
use Maatwebsite\Excel\Concerns\WithTitle;
use PhpOffice\PhpSpreadsheet\Style\Border;
use Illuminate\Database\Eloquent\Collection;
use Maatwebsite\Excel\Events\AfterSheet;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Cell\DataValidation;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use Suiterus\Dms\Models\Approvals\UserApprover;
use Illuminate\Support\Facades\Auth;
use Suiterus\Dms\Models\CustomForm\CustomForm;

class ApprovalsExportSheet implements FromCollection, WithTitle, WithStyles, WithEvents
{

    private $title;
    private $records;
    private $user;

    public function __construct($title, $rows, $data)
    {
        $this->title = $title;
        $this->records = $rows;
        $this->data = $data;
    }

    /**
     * @return Builder
     */
    public function collection()
    {
        return new Collection();
    }

    /**
     * @return string
     */
    public function title(): string
    {
        return $this->title;
    }

    public function styles(Worksheet $sheet)
    {
        if ($this->title == "APPROVALS_ENDORSED_DOCUMENTS") {

            $customFormValue = CustomForm::first();
            $isSetCustomForm = isset($customFormValue['form']);
            if ($isSetCustomForm) {
                $customFormValue['form'] = json_decode($customFormValue['form']);

                $customFormValue['form'] = array_map(function ($item) {
                    return $item->label;
                }, $customFormValue['form']);
            }

            $cell = 'E';
            $cell++;

            $cellRange = 'E';
            if ($isSetCustomForm) {
                for ($i = 0; $i < count($customFormValue['form']); $i++) {
                    $cellRange++;
                }
            }

            $sheet->getStyle("A1:" . $cellRange . "1")->getFont()->setBold(true);

            $style = array(
                'alignment' => array(
                    'horizontal' => Alignment::HORIZONTAL_CENTER
                )
            );

            $sheet->getStyle("A1:" . $cellRange . "1")->applyFromArray($style);

            // Column Width
            $sheet->getColumnDimension("A")->setAutoSize(true);
            $sheet->getColumnDimension("B")->setAutoSize(true);
            $sheet->getColumnDimension("C")->setAutoSize(true);
            $sheet->getColumnDimension("D")->setAutoSize(true);
            $sheet->getColumnDimension("E")->setAutoSize(true);

            if ($isSetCustomForm) {
                foreach ($customFormValue['form'] as $key => $value) {
                    $sheet->getColumnDimension($cell)->setAutoSize(true);
                    $sheet->setCellValue($cell . "1", $value);
                    $cell++;
                }
            }

            $sheet->getRowDimension(1)->setRowHeight("30");

            // styling header
            $styleArray = array(
                'borders' => array(
                    'allBorders' => array(
                        'borderStyle' => Border::BORDER_THIN,
                        'color' => array('argb' => '00000000'),
                    ),
                ),
                'alignment' => [
                    'vertical' => Alignment::VERTICAL_CENTER,
                    'horizontal' => Alignment::HORIZONTAL_CENTER,
                    'wrapText' => true
                ],
                ''
            );

            for ($i = 1; $i < $this->records + 2; $i++) {
                $sheet->getStyle("A" . $i . ":" . $cellRange .  $i)->applyFromArray($styleArray);
            }

            $sheet->setCellValue("A1", "File Name");
            $sheet->setCellValue("B1", "Document Type");
            $sheet->setCellValue("C1", "Date Created");
            $sheet->setCellValue("D1", "Date Endorsed");
            $sheet->setCellValue("E1", "Status");
        }
    }

    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function (AfterSheet $event) {

                /** @var Sheet $sheet */
                $sheet = $event->sheet;

                foreach ($this->data as $key => $value) {
                    $sheet->setCellValue("A" . ($key + 2), $value->fileApprover->approval->file->file_name);
                    $sheet->setCellValue("B" . ($key + 2), $value->fileApprover->approval->file->file->documentType == null ? "N/A" : $value->fileApprover->approval->file->file->documentType->name);
                    $sheet->setCellValue("C" . ($key + 2), $value->fileApprover->approval->created_at);
                    $sheet->setCellValue("D" . ($key + 2), $value->fileApprover->approval->updated_at);
                    $sheet->setCellValue("E" . ($key + 2), $value->fileApprover->approval->file->is_obsolete == 1 ? "Obsolete" : "Active");

                    if (!empty($value->fileApprover->approval->file->customFormValue->values)) {
                        $customFormValue = $value->fileApprover->approval->file->customFormValue->values;
                        $customFormValue = json_decode($customFormValue);
                        $cell = 'E';
                        $cell++;
                        foreach ($customFormValue as $form) {
                            $sheet->setCellValue($cell . ($key + 2), $form->value);
                            $cell++;
                        }
                    }
                }
            }
        ];
    }
}
