<?php

namespace Suiterus\Dms\Controllers\SectionManager;

use Illuminate\Database\Eloquent\ModelNotFoundException as ME;
use Suiterus\Dms\Models\Repositories\SectionAccess;
use Suiterus\Dms\Models\Repositories\Section;
use App\Http\Controllers\Controller;
use Spatie\Permission\Models\Role;
use Suiterus\Dms\Models\Files\File as SF;
use Suiterus\Dms\Models\Files\FileField as SFF;
use Illuminate\Http\Request;
use App\Models\User;
use Carbon\Carbon;
use Validator;
use Exception;
use Auth;
use DB;

class RepositoriesController extends Controller
{

    public function section_list(Request $req){
        //DB::connection()->enableQueryLog();
        $id = $req->parent_id;
        if($id != 0){
            try{
                $d = Section::whereId($req->parent_id)->firstOrFail();
                if($d->type === 1){
                    $valid = false;
                    foreach($d->access as $dd){
                        if($dd->user_id === Auth::user()->id){
                            $valid = true;
                        }else{
                            if($dd->group_id !== null && Auth::user()->hasAnyRole($dd->group_id)){
                                $valid = true;
                            }
                        }
                    }
                    //return $d->access;
                    if($valid){
                        return $this->fetchRepos($id);
                    }else{
                        return response()->json([
                            'errors'    =>  [ 'Not permitted to visit. 1' ]
                        ],403);
                    }
                }else{
                    return $this->fetchRepos($id);
                }
            }catch(ME $e){
                return response()->json([
                    'errors'    =>  [ 'Not permitted to visit. 2' ]
                ],403);
            }
        }else{
            return $this->fetchRepos($id);
        }
    }

    public function fetchRepos($id = 0){
        try{
            $sections = Section::where([ 'parent_id' => $id ])->get();
            $d = $sections->map(function($v){
                if($v->type == 2){
                    return $v;
                }else{
                    $valid = false;
                    foreach($v->access as $ac){
                        if($ac->user_id === Auth::user()->id){
                            $valid = true;
                            break;
                        }else{
                            if($ac->group_id !== null && Auth::user()->hasAnyRole($ac->group_id)){
                                $valid = true;
                            }
                        }
                    }
                    if($valid){
                        return $v;
                    }else{
                        return false;
                    }
                }
            })->toArray();
            $files = SF::where([ 'section_id' => $id ])->get();
            $df = $files->map(function($v){
                if($v->type == 2){
                    return $v;
                }else{
                    $valid = false;
                    foreach($v->access as $ac){
                        if($ac->user_id === Auth::user()->id){
                            $valid = true;
                            break;
                        }else{
                            if($ac->group_id !== null && Auth::user()->hasAnyRole($ac->group_id)){
                                $valid = true;
                            }
                        }
                    }
                    if($valid){
                        return $v;
                    }else{
                        return false;
                    }
                }
            })->toArray();
            $ddd = [];
            foreach($d as $dd){
                if($dd != false){
                    $dd['file_type'] = 'folder';
                    $ddd[] = $dd;
                }
            }
            foreach($df as $file){
                $file['file_type'] = 'file';
                $ddd[] = $file;
            }
            return response()->json([
                'data'  =>  $ddd,
                'parent'    =>  Section::whereId($id)->firstOrFail(),
                'breadcrumbs'   =>  $this->breadcrumbs(Section::whereId($id)->firstOrFail())
            ]);
        }catch(ME $e){
            $parent = null;
            $sections = Section::where([ 'parent_id' => $id ])->get();
            $d = $sections->map(function($v){
                if($v->type == 2){
                    return $v;
                }else{
                    $valid = false;
                    foreach($v->access as $ac){
                        if($ac->user_id === Auth::user()->id){
                            $valid = true;
                            break;
                        }else{
                            if($ac->group_id !== null &&  Auth::user()->hasRole($ac->group_id)){
                                $valid = true;
                            }
                        }
                    }
                    if($valid){
                        return $v;
                    }else{
                        return false;
                    }
                }
            })->toArray();
            $files = SF::where([ 'section_id' => $id ])->get();
            $df = $files->map(function($v){
                if($v->type == 2){
                    return $v;
                }else{
                    $valid = false;
                    foreach($v->access as $ac){
                        if($ac->user_id === Auth::user()->id){
                            $valid = true;
                            break;
                        }else{
                            if($ac->group_id !== null && Auth::user()->hasAnyRole($ac->group_id)){
                                $valid = true;
                            }
                        }
                    }
                    if($valid){
                        return $v;
                    }else{
                        return false;
                    }
                }
            })->toArray();
            $ddd = [];
            foreach($d as $dd){
                if($dd != false){
                    $dd['file_type'] = 'folder';
                    $ddd[] = $dd;
                }
            }
            if(count($df)){
                foreach($df as $file){
                    if($file != false){
                        $file['file_type'] = 'file';
                        $ddd[] = $file;
                    }
                }
            }
            /*$itemsTransformedAndPaginated = new \Illuminate\Pagination\LengthAwarePaginator(
                $ddd,
                $sections->total(),
                $sections->perPage(),
                $sections->currentPage(), [
                    'path' => \Request::url(),
                    'query' => [
                        'page' => $sections->currentPage()
                    ]
                ]
            );*/
            return response()->json([
                'data'  =>  $ddd,
                'parent'    =>  null,
                'breadcrumbs'   =>  [
                    [
                        'id'    =>  0,
                        'name'  =>  'Repositories'
                    ]
                ]
            ]);
        }
    }

    public function fetchReposGetMethod($id = 0){
        try{
            $sections = Section::where([ 'parent_id' => $id ])->get();
            $d = $sections->map(function($v){
                if($v->type == 2){
                    return $v;
                }else{
                    $valid = false;
                    foreach($v->access as $ac){
                        if($ac->user_id === Auth::user()->id){
                            $valid = true;
                            break;
                        }else{
                            if($ac->group_id !== null && Auth::user()->hasAnyRole($ac->group_id)){
                                $valid = true;
                            }
                        }
                    }
                    if($valid){
                        return $v;
                    }else{
                        return false;
                    }
                }
            })->toArray();
            $ddd = [];
            $ddd[] = Section::whereId($id)->firstOrFail();
            foreach($d as $dd){
                if($dd != false){
                    $ddd[] = $dd;
                }
            }
            return response()->json([
                'data'  =>  $ddd
            ]);
        }catch(ME $e){
            $parent = null;
            $sections = Section::where([ 'parent_id' => $id ])->get();
            $d = $sections->map(function($v){
                if($v->type == 2){
                    return $v;
                }else{
                    $valid = false;
                    foreach($v->access as $ac){
                        if($ac->user_id === Auth::user()->id){
                            $valid = true;
                            break;
                        }else{
                            if($ac->group_id !== null &&  Auth::user()->hasRole($ac->group_id)){
                                $valid = true;
                            }
                        }
                    }
                    if($valid){
                        return $v;
                    }else{
                        return false;
                    }
                }
            })->toArray();
            $ddd = [];
            $ddd[] = [
                'name'  =>  'ROOT DIRECTORY',
                'id'    =>  '0x027'
            ];
            foreach($d as $dd){
                if($dd != false){
                    $ddd[] = $dd;
                }
            }
            return response()->json([
                'data'  =>  $ddd
            ]);
        }
    }

    public function breadcrumbs($items){
        $stop = false;
        $data = [];
        if($items === null){
            return $data;
        }
        $item = $items;
        $item['disabled'] = true;
        $data[] = $item;
        while($item->parent !== null){
            if($item->parent === null){
                break;
            }
            $x = $item['parent'];
            $x['disabled'] = false;
            $data[] = $x;
            $item = $item['parent'];
        }
        $data[] = [
            'id'    =>  0,
            'name'  =>  'Repositories'
        ];
        return array_reverse($data);
    }

    public function user_search(Request $req){
        $user = User::select('id', 'name', 'email')->where(function($q) use ($req){
            return $q->where('name', 'LIKE', '%'.$req->keyword.'%')->orWhere('email', 'LIKE', '%'.$req->keyword.'%');
        })->where('id', '!=', Auth::user()->id)->take(5)->cursor();
        $group = Role::select('id', 'name')->where('name', 'LIKE', '%'.$req->keyword.'%')->where('name', '!=', 'Developer')->take(5)->cursor();
        $group = $group->merge($user);
        return response()->json([
            'data'  =>  $group
        ]);
    }

    public function section_create(Request $req){
        $valid = Validator::make($req->all(),[
            'name'  =>  'required|min:3|string|unique:dms_db.sections',
            'description'   =>  'required|string|min:3',
            'parent_id' =>  'nullable|numeric',
            'type'  =>  'required|numeric',
            'access'    =>  'nullable|array'
        ]);
        if($valid->fails()){
            return response()->json([
                'errors'    =>  $valid->errors()
            ],400);
        }
        DB::beginTransaction();
        try{
            $s = Section::create([
                'name'              =>  $req->name,
                'description'       =>  $req->description,
                'type'              =>  $req->type,
                'parent_id'         =>  $req->parent_id === null ? 0 : $req->parent_id,
                'status'            =>  1
            ]);
            if($req->type === 1){
                //adding current user to access
                $s->access()->create([
                    'user_id'   =>  Auth::user()->id,
                    'access_level'  =>  1
                ]);
                //adding all devs to access
                $devs = Role::where([ 'name' => 'Developer' ]);
                if($devs->count()){
                    if($s->access()->where([ 'group_id' => $devs->first()->id ])->count() == 0){
                        $s->access()->create([
                            'user_id'   =>  0,
                            'group_id'   =>  $devs->first()->id,
                            'access_level'  =>  1,
                            'shared_by' => Auth::id(),
                            'shared_date' => now()
                        ]);
                    }
                }
                //adding more user
                if($req->access !== null && count($req->access)){
                    foreach($req->access as $access){
                        $access = (object) $access;
                        if(isset($access->email)){
                            if($access->id !== Auth::user()->id){
                                $s->access()->create([
                                    'user_id'   =>  $access->id,
                                    'group_id'   =>  0,
                                    'access_level'  =>  2,
                                    'shared_by' => Auth::id(),
                                    'shared_date' => now()
                                ]);
                            }
                        }else{
                            $s->access()->create([
                                'user_id'   =>  0,
                                'group_id'   => $access->id,
                                'access_level'  =>  2,
                                'shared_by' => Auth::id(),
                                'shared_date' => now()
                            ]);
                        }
                    }
                }
            }
            DB::commit();
            return response()->json([
                'text'  =>  'Section has been created.'
            ]);
        }catch(Exception $e){
            DB::rollback();
            return response()->json([
                'errors'    =>  [ 'Something went wrong in our system. Please contact the developer to fix it.' ],
                'message'   =>  $e->getMessage()
            ],500);
        }
    }

    public function section_update(Request $req){
        $valid = Validator::make($req->all(),[
            'name'  =>  'required|min:3|string|unique:dms_db.sections,name,'.$req->id,
            'description'   =>  'required|string|min:3',
            'parent_id' =>  'nullable|numeric'
        ]);
        if($valid->fails()){
            return response()->json([
                'errors'    =>  $valid->errors()
            ],400);
        }
        DB::beginTransaction();
        try{
            try{
                $s = Section::findOrFail($req->id);
                $s = $s->update([
                    'name'              =>  $req->name,
                    'description'       =>  $req->description,
                    'parent_id'         =>  $req->parent_id === null ? 0 : $req->parent_id,
                    'status'            =>  1
                ]);
                DB::commit();
                return response()->json([
                    'text'  =>  'Section has been updated.'
                ]);
            }catch(ME $ee){
                DB::rollback();
                return response()->json([
                    'errors'    =>  [ 'Section not found.' ]
                ],500);
            }
        }catch(Exception $e){
            DB::rollback();
            return response()->json([
                'errors'    =>  [ 'Something went wrong in our system. Please contact the developer to fix it.' ]
            ],500);
        }
    }

    public function section_config_access_level(Request $req){
        DB::beginTransaction();
        try{
            try{
                $ac = SectionAccess::findOrFail($req->id);
                $ac->access_level = $req->access_level;
                $ac->save();
                DB::commit();
                return true;
            }catch(ME $ee){
                DB::rollback();
                return response()->json([
                    'errors'    =>  [ 'Access level not found.' ]
                ],500);
            }
        }catch(Exception $e){
            DB::rollback();
            return response()->json([
                'errors'    =>  [ 'Something went wrong in our system. Please contact the developer to fix it.' ]
            ],500);
        }
    }

    public function section_config(Request $req){
        $valid = Validator::make($req->all(),[
            'type'  =>  'required|numeric',
            'new_access'    =>  'nullable|array',
            'new_access_level'  =>  'nullable|numeric'
        ]);
        if($valid->fails()){
            return response()->json([
                'errors'    =>  $valid->errors()
            ],400);
        }
        DB::beginTransaction();
        try{
            try{
                $s = Section::findOrFail($req->id);
                $s->type = $req->type;
                if($req->type === 1){
                    if(!$s->access()->where([ 'user_id' => Auth::user()->id ])->count()){
                        $s->access()->create([
                            'user_id'       =>  Auth::user()->id,
                            'access_level'  =>  1
                        ]);
                    }
                    //adding all devs to access
                    $devs = Role::where([ 'name' => 'Developer' ]);
                    if($devs->count()){
                        if($s->access()->where([ 'group_id' => $devs->first()->id ])->count() == 0){
                            $s->access()->create([
                                'user_id'   =>  0,
                                'group_id'   =>  $devs->first()->id,
                                'access_level'  =>  1,
                                'shared_by' => Auth::id(),
                                'shared_date' => now()
                            ]);
                        }
                    }
                    if($req->new_access && count($req->new_access)){
                        foreach($req->new_access as $na){
                            $na = (object) $na;
                            if(isset($na->email)){
                                try{
                                    $s->access()->where([ 'user_id' => $na->id ])->where('user_id', '!=', 0)->firstOrFail();
                                }catch(ME $ee){
                                    $s->access()->create([
                                        'user_id'       =>  $na->id,
                                        'group_id'       =>  0,
                                        'access_level'  =>  $req->new_access_level,
                                        'shared_by' => Auth::id(),
                                        'shared_date' => now()
                                    ]);
                                }

                            }else{
                                try{
                                    $s->access()->where([ 'group_id' => $na->id ])->where('group_id', '!=', NULL)->firstOrFail();
                                }catch(ME $ee){
                                    $s->access()->create([
                                        'user_id'       =>  0,
                                        'group_id'       =>  $na->id,
                                        'access_level'  =>  $req->new_access_level,
                                        'shared_by' => Auth::id(),
                                        'shared_date' => now()
                                    ]);
                                }
                            }
                        }
                    }
                }else{
                    $s->access()->delete();
                }
                $s->save();
                DB::commit();
                return response()->json([
                    'text'  =>  'section configuration has been updated.'
                ]);
            }catch(ME $ee){
                DB::rollback();
                return response()->json([
                    'errors'    =>  [ 'Access level not found.' ]
                ],500);
            }
        }catch(Exception $e){
            DB::rollback();
            return response()->json([
                'errors'    =>  [ 'Something went wrong in our system. Please contact the developer to fix it.' ],
                'msg'   =>  $e->getMessage()
            ],500);
        }
    }

    public function section_config_access_level_delete(Request $req){
        DB::beginTransaction();
        try{
            try{
                $ac = SectionAccess::findOrFail($req->id);
                $ac->delete();
                DB::commit();
                return response()->json([
                    'text'  =>  'Access Level has been deleted'
                ]);
            }catch(ME $ee){
                DB::rollback();
                return response()->json([
                    'errors'    =>  [ 'Access level not found.' ]
                ],500);
            }
        }catch(Exception $e){
            DB::rollback();
            return response()->json([
                'errors'    =>  [ 'Something went wrong in our system. Please contact the developer to fix it.' ],
                'msg'   =>  $e->getMessage()
            ],500);
        }
    }

    public function templates_all(Request $req){
        $id = $req->id;
        if($id != 0){
            try{
                $d = Section::whereId($req->id)->firstOrFail();
                if($d->type === 1){
                    $valid = false;
                    foreach($d->access as $dd){
                        if($dd->user_id === Auth::user()->id){
                            $valid = true;
                        }else{
                            if($dd->group_id !== null &&  Auth::user()->hasRole($dd->group_id)){
                                $valid = true;
                            }
                        }
                    }
                    //return $d->access;
                    if($valid){
                        return $this->fetchReposGetMethod($id);
                    }else{
                        return response()->json([
                            'errors'    =>  [ 'Not permitted to visit. 1' ]
                        ],403);
                    }
                }else{
                    return $this->fetchReposGetMethod($id);
                }
            }catch(ME $e){
                return response()->json([
                    'errors'    =>  [ 'Not permitted to visit. 2' ]
                ],403);
            }
        }else{
            return $this->fetchReposGetMethod($id);
        }
    }

    public function single_upload(Request $req){
        $valid = Validator::make($req->all(),[
            'name'      =>  'required|string|min:3',
            'section'   =>  'required',
            'privacy'   =>  'required|numeric',
            'extras'    =>  'nullable|array',
            'file'      =>  'required|mimes:xls,xlsx,doc,docx,pdf,jpg,jpeg,png,mp3,mp4,3pg,f4v,tiff,wav,ogg,aiff,mkv,flac,flv,wmv,tif,gif'
        ]);
        if($valid->fails()){
            return response()->json([
                'errors'    =>  $valid->errors()
            ],400);
        }
        DB::beginTransaction();
        try{
            try{
                $section = $req->section == '0x027' ? 0 : $req->section;
                if(SF::where([ 'section_id' => $section, 'name' =>  $req->name ])->count()){
                    return response()->json([
                        'errors'    =>  [ 'File Name already exists on this template.' ]
                    ],400);
                }
                if($section != 0){
                    $main = Section::findOrFail($section);
                    $sex = SF::create([
                        'section_id'        =>  $section,
                        'user_id'           =>  Auth::user()->id,
                        'name'              =>  $req->name,
                        'type'              =>  $req->privacy,
                        'modified_by'       =>  0,
                        'effectivity'       =>  Carbon::parse($req->effectivity . ' 00:01:59'),
                        'expiry'            =>  Carbon::parse($req->expiry . ' 00:01:59')
                    ]);
                }else{
                    $sex = SF::create([
                        'section_id'        =>  0,
                        'user_id'           =>  Auth::user()->id,
                        'name'              =>  $req->name,
                        'type'              =>  $req->privacy,
                        'modified_by'       =>  0,
                        'effectivity'       =>  Carbon::parse($req->effectivity . ' 00:01:59'),
                        'expiry'            =>  Carbon::parse($req->expiry . ' 00:01:59')
                    ]);
                }
                if($req->extras && count($req->extras)){
                    foreach($req->extras as $extra){
                        $sex->extraFields()->create([
                            'extra_name'        =>  $extra['name'],
                            'extra_value'       =>  $extra['value'],
                            'status'            =>  0
                        ]);
                    }
                }
                //give access
                if($req->privacy == 1){
                    //return "test";
                    //adding user to access
                    $sex->access()->create([
                        'user_id'   =>  Auth::user()->id,
                        'access_level'  =>  1
                    ]);
                    //adding all devs to access
                    $devs = Role::where([ 'name' => 'Developer' ]);
                    if($devs->count()){
                        if($sex->access()->where([ 'group_id' => $devs->first()->id ])->count() == 0){
                            $sex->access()->create([
                                'user_id'   =>  0,
                                'group_id'   =>  $devs->first()->id,
                                'access_level'  =>  1,
                                'shared_by' => Auth::id(),
                                'shared_date' => now()
                            ]);
                        }
                    }
                    //adding more user
                    if($req->access !== null && count($req->access)){
                        foreach($req->access as $access){
                            $access = (object) $access;
                            if(isset($access->email)){
                                if($access->id !== Auth::user()->id){
                                    $sex->access()->create([
                                        'user_id'   =>  $access->id,
                                        'group_id'   =>  0,
                                        'access_level'  =>  2,
                                        'shared_by' => Auth::id(),
                                        'shared_date' => now()
                                    ]);
                                }
                            }else{
                                $sex->access()->create([
                                    'user_id'   =>  0,
                                    'group_id'   => $access->id,
                                    'access_level'  =>  2,
                                    'shared_by' => Auth::id(),
                                    'shared_date' => now()
                                ]);
                            }
                        }
                    }
                }
                DB::commit();
                return response()->json([
                    'text'  =>  'File has been uploaded!.'
                ]);
            }catch(ME $ee){
                DB::rollback();
                return response()->json([
                    'errors'    =>  [ 'Template Section not found.' ],
                    'msg'   =>  $e->getMessage()
                ],400);
            }
        }catch(Exception $e){
            DB::rollback();
            return response()->json([
                'errors'    =>  [ 'Something went wrong in our system. Please contact the developer to fix it.' ],
                'msg'   =>  $e->getMessage()
            ],500);
        }
    }

}
