<?php

namespace Suiterus\Dms\Controllers\SectionManager;

use Illuminate\Routing\Controller;
use Illuminate\Http\JsonResponse;
use Pion\Laravel\ChunkUpload\Exceptions\UploadFailedException;
use Illuminate\Http\Request;
use Pion\Laravel\ChunkUpload\Exceptions\UploadMissingFileException;
use Pion\Laravel\ChunkUpload\Handler\AbstractHandler;
use Pion\Laravel\ChunkUpload\Handler\HandlerFactory;
use Pion\Laravel\ChunkUpload\Receiver\FileReceiver;
use Suiterus\Dms\Request\File\BatchFileUploadRequest;
use Suiterus\Dms\Services\File\BatchUploadService;

class BatchUploadController extends Controller
{

    private $batchUploadService;

    public function __construct(BatchUploadService $batchUploadService)
    {
        $this->batchUploadService = $batchUploadService;
    }

    /**
     * Handles the file upload
     *
     * @param Request $request
     *
     * @return JsonResponse
     *
     * @throws UploadMissingFileException
     * @throws UploadFailedException
     */
    public function batchUpload(BatchFileUploadRequest $request)
    {

        //to avoid duplication, sleep is added
        sleep(0.3);

        // create the file receiver
        $receiver = new FileReceiver("file", $request, HandlerFactory::classFromRequest($request));

        // check if the upload is success, throw exception or return response you need
        if ($receiver->isUploaded() === false) {
            throw new UploadMissingFileException();
        }

        // receive the file
        $save = $receiver->receive();

        // check if the upload has finished (in chunk mode it will send smaller files)
        if ($save->isFinished()) {
            // set other parameters for private drive type
            // save the file and return any response you need, current example uses `move` function. If you are
            // not using move, you need to manually delete the file by unlink($save->getFile()->getPathname())
            $this->batchUploadService->setDocumentType($request->document_type)->setPrivacy($request->privacy)
                ->setUsers(json_decode($request->users))
                ->setGroups(json_decode($request->groups))->saveFile(
                    $save->getFile(),
                    $request->resumableRelativePath,
                    $request->drive_type,
                    $request->section_id
                );
        }

        // we are in chunk mode, lets send the current progress
        /** @var AbstractHandler $handler */
        $handler = $save->handler();

        return response()->json([
            "done" => $handler->getPercentageDone(),
            'status' => true
        ]);
    }
}
