<?php

namespace Suiterus\Dms\Controllers\Repositories;

use App\Enums\Dms\DriveType;
use Illuminate\Database\Eloquent\ModelNotFoundException as ME;
use Suiterus\Dms\Models\Repositories\Section;
use Illuminate\Support\Facades\Storage;
use App\Http\Controllers\Controller;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Collection;
use Suiterus\Dms\Models\Files\File as SF;
use Illuminate\Http\Request;
use Validator;
use Exception;
use Auth;
use DB;
use Suiterus\Dms\Services\Repositories\PublicFolderService;

class PublicFolderController extends FolderController
{

    public function search_folder(Request $req)
    {
        $data = $this->searchFolder($req, new PublicFolderService);
        return response()->json([
            'data' => $data
        ]);
    }

    public function search_file(Request $req)
    {
        $data = $this->searchFile($req, new PublicFolderService);

        return response()->json([
            'data'  => $data
        ]);
    }
    //For Repositories tab
    public function list_root_folder(Request $req)
    {
        $data = $this->listRootFolder($req, new PublicFolderService);
        return response()->json([
            'data' => $data,
        ]);
    }

    // Fetch list of sections to which folders/files can be moved/copied.
    public function list_public_folders(Request $req)
    {
        $data = $this->movableFolderList($req->folders, new DriveType, $req->id ?? 0, new PublicFolderService);

        return response()->json([
            'data' => $data
        ]);
    }
}
