<?php

namespace Suiterus\Dms\Controllers\Repositories;

use App\Enums\Dms\DriveType;
use Illuminate\Database\Eloquent\ModelNotFoundException as ME;
use App\Models\AccessManagement\GroupManagement\ModelHasRole;
use App\Models\AccessManagement\GroupManagement\Role;
use Suiterus\Dms\Models\Repositories\SectionAccess;
use Suiterus\Dms\Models\Repositories\Section;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Collection;
use App\Http\Controllers\Controller;
use Suiterus\Dms\Models\Files\File as SF;
use Illuminate\Http\Request;
use App\Models\User;

use Validator;
use Exception;
use Auth;
use DB;
use Suiterus\Dms\Services\Repositories\PrivateFolderService;

class PrivateFolderController extends FolderController
{
    public function search_folder(Request $req)
    {
        $data = $this->searchFolder($req, new PrivateFolderService);
        return response()->json([
            'data' => $data
        ]);
    }

    public function search_file(Request $req)
    {
        $data = $this->searchFile($req, new PrivateFolderService);

        return response()->json([
            'data'  => $data
        ]);
    }

    //For Repositories tab
    public function list_root_folder(Request $req)
    {
        $data = $this->listRootFolder($req, new PrivateFolderService);

        return response()->json([
            'data' => $data,
        ]);
    }
    //For Folders tab
    public function fetch_folders($id = 0, $paginate = PHP_INT_MAX)
    {
        try {
            $authRoles = Auth::user()->roles->pluck('id');
            $sectionsPrivate = Section::where([
                'parent_id' => $id,
                'type' => DriveType::PRIVATE
            ])->whereHas('access', function($query) use($authRoles){
                $query->where('user_id', Auth::user()->id)->orWhereIn('group_id', $authRoles);
            })->without(['author'])->take(10)->get();
            $sectionsPersonal = Section::where([
                'parent_id' => $id,
                'type' => DriveType::PERSONAL
            ])->whereHas('access', function($query) use($authRoles){
                $query->where('user_id', Auth::user()->id)->orWhereIn('group_id', $authRoles);
            })->without(['author'])->take(10)->get();
           $sectionsPublic = Section::where([
                'parent_id' => $id,
                'type' => DriveType::PUBLIC
            ])->without(['author'])->take(10)->get();
            // $d = $sections
            //     ->map(function ($v) {
            //         if ($v->type == 2) {
            //             return $v;
            //         } else {
            //             $valid = false;
            //             foreach ($v->access as $ac) {
            //                 if ($ac->user_id === Auth::user()->id) {
            //                     $valid = true;
            //                     break;
            //                 } else {
            //                     if ($ac->group_id !== null && Auth::user()->hasAnyRole($ac->group_id)) {
            //                         $valid = true;
            //                     }
            //                 }
            //             }
            //             if ($valid) {
            //                 return $v;
            //             } else {
            //                 return false;
            //             }
            //         }
            //     })
            //     ->toArray();
            $folders = [...$sectionsPrivate,...$sectionsPersonal,...$sectionsPublic];
            // foreach ($d as $dd) {
            //     if ($dd) {
            //         $dd['file_type'] = 'folder';
            //         $folders[] = $dd;
            //     }
            // }

            return response()->json([
                'data' => $folders,
                'breadcrumbs' => FolderController::breadcrumbs(Section::whereId($id)->without(['author'])->firstOrFail()),
                'parent' => Section::whereId($id)->without(['author'])->firstOrFail(),
            ]);
        } catch (ME $e) {

            $sectionsPrivate = Section::where([
                'parent_id' => $id,
                'type' => DriveType::PRIVATE
            ])->whereHas('access', function($query) use($authRoles) {
                $query->where('user_id', Auth::user()->id)->orWhereIn('group_id', $authRoles);
            })->without(['author'])->take(10)->get();
            $sectionsPersonal = Section::where([
                'parent_id' => $id,
                'type' => DriveType::PERSONAL
            ])->whereHas('access', function($query) use($authRoles) {
                $query->where('user_id', Auth::user()->id)->orWhereIn('group_id', $authRoles);
            })->without(['author'])->take(10)->get();
           $sectionsPublic = Section::where([
                'parent_id' => $id,
                'type' => DriveType::PUBLIC
            ])->without(['author'])->take(10)->get();
            // $d = $sections
            //     ->map(function ($v) {
            //         if ($v->type == 2) {
            //             return $v;
            //         } else {
            //             $valid = false;
            //             foreach ($v->access as $ac) {
            //                 if ($ac->user_id === Auth::user()->id) {
            //                     $valid = true;
            //                     break;
            //                 } else {
            //                     if ($ac->group_id !== null && Auth::user()->hasRole($ac->group_id)) {
            //                         $valid = true;
            //                     }
            //                 }
            //             }
            //             if ($valid) {
            //                 return $v;
            //             } else {
            //                 return false;
            //             }
            //         }
            //     })
            //     ->toArray();
            $folders = [...$sectionsPrivate,...$sectionsPersonal,...$sectionsPublic];
            // foreach ($d as $dd) {
            //     if ($dd) {
            //         $dd['file_type'] = 'folder';
            //         $folders[] = $dd;
            //     }
            // }
            return response()->json([
                'data' => $folders,
                'parent' => null,
                'breadcrumbs' => [
                    [
                        'id' => 0,
                        'name' => 'Repositories',
                    ],
                ],
            ]);
        }
    }

    public function fetch_groups(Request $req)
    {
        $data = Role::whereHas('roleHasSystem', function (Builder $query) {
            $query->where('system_id', 1);
        })->get();

        $currentGroupAccess = Role::whereHas('sectionAccess', function (Builder $query) use ($req) {
            $query->where('section_id', $req->section_id);
        })->get();

        return response()->json([
            'data' => $data,
            'currentGroupAccess' => $currentGroupAccess,
        ]);
    }

    public function fetch_users(Request $req)
    {
        $data = User::whereNotIn('name', ['Developer Account', 'System Account'])->without(['roles', 'permissions', 'supervisor', 'employeeMetaInfo', 'storage'])->get(['id', 'name']);
        $section = Section::whereId($req->section_id)->first();
        $groupIds = $section->access()->pluck('group_id');
        $sectionId = $req->section_id;
        $currentUserAccess = User::whereNotIn('id', [1, 2])
            ->whereHas('section_access', function (Builder $query) use ($groupIds, $sectionId) {
                $query->whereIn('id', $groupIds)->orWhere('section_id', $sectionId);
            })->get(['id', 'name']);

        return response()->json([
            'data' => $data,
            'currentUserAccess' => $currentUserAccess,
        ]);
    }

    public function user_search(Request $req)
    {
        $user = User::select('id', 'name', 'email')
            ->where(function ($q) use ($req) {
                return $q->where('name', 'LIKE', '%' . $req->keyword . '%')->orWhere('email', 'LIKE', '%' . $req->keyword . '%');
            })
            ->where('id', '!=', Auth::user()->id)
            ->take(5)
            ->cursor();
        $group = Role::select('id', 'name')
            ->where('name', 'LIKE', '%' . $req->keyword . '%')
            ->where('name', '!=', 'Developer')
            ->take(5)
            ->cursor();
        $group = $group->merge($user);
        return response()->json([
            'data' => $group,
        ]);
    }

    // Fetch list of sections to which folders/files can be moved/copied.
    public function list_private_folders(Request $req)
    {

        $data = $this->movableFolderList($req->folders, new DriveType, $req->id ?? 0, new PrivateFolderService);

        return response()->json([
            'data' => $data
        ]);
    }

    public function configure_access(Request $req)
    {
        $valid = Validator::make($req->all(), [
            'section_id' => 'required|numeric|exists:dms_db.sections,id',
        ]);

        if ($valid->fails()) {
            return response()->json([
                'errors' => $valid->errors(),
            ], 400);
        }

        DB::beginTransaction();
        try {
            $data = Section::whereId($req->section_id)->without('files')->first();

            $initial_group = $data->access->whereNotNull('group')
                ->whereNotIn('group.name', ['Developer', 'Admin', 'Super Admin'])
                ->pluck('group_id')->toArray();

            $initial_user = $data->access->whereNotIn('user_id', [1, 2, 0])->pluck('user_id')->toArray();

            $userAccess = collect($req->userAccess)->pluck('id')->toArray();
            $groupAccess = collect($req->groupAccess)->pluck('id')->toArray();
            $old_users = $this->compare_array($initial_user, $userAccess);
            $old_groups = $this->compare_array($initial_group, $groupAccess);

            SectionAccess::whereIn('user_id', $old_users)
                ->orWhereIn('group_id', $old_groups)
                ->forceDelete();

            if (!empty($req->userAccess)) {
                foreach ($userAccess as $user) {
                    $data->access()->firstOrCreate([
                        'user_id' => $user,
                        'access_level' => 2,
                        'shared_by' => Auth::id(),
                        'shared_date' => now()
                    ]);
                }
            }

            if (!empty($req->groupAccess)) {
                foreach ($groupAccess as $group) {
                    $data->access()->firstOrCreate([
                        'user_id' => 0,
                        'group_id' => $group,
                        'access_level' => 2,
                        'shared_by' => Auth::id(),
                        'shared_date' => now()
                    ]);
                }
            }

            DB::commit();
            return response()->json([
                'message' => 'Folder access has been configure',
            ]);
        } catch (\Exception $e) {
            DB::rollback();
            return response()->json([
                'errors'    =>  ['Something went wrong in our system. Please contact the developer to fix it.'],
                'message'   =>  $e->getMessage()
            ], 500);
        }
    }

    public function compare_array($array1, $array2)
    {
        return array_diff($array1, $array2);
    }

    public function approvalFetchFiles(Request $request)
    {
        $paginate = $request->page_count ? intval($request->page_count) : ENV('DEFAULT_PAGECOUNT');
        $data = SF::where('name', 'LIKE', '%' . $request->keyword . '%')
            ->whereHas('versions', function ($query) {
                $query->whereHas('approval', function ($query) {
                    $query->where('user_id', Auth::id())
                        ->orWhereHas('fileApprover', function ($query) {
                            $query->whereHas('userApprover', function ($query) {
                                $query->where('user_id', Auth::id());
                            });
                        });
                });
            })->without('modifier', 'extraFields', 'access', 'documentType')->paginate($paginate);
        return $data;
    }

    public function forwardFetchFiles(Request $request)
    {
        $paginate = $request->page_count ? intval($request->page_count) : ENV('DEFAULT_PAGECOUNT');
        return SF::where('name', 'LIKE', '%' . $request->keyword . '%')
            ->whereHas('forward', function ($query) {
                $query->where('user_id', Auth::id())
                    ->orWhere('created_by', Auth::id());
            })->without('modifier', 'extraFields', 'access', 'documentType')->paginate($paginate);
    }

    public function assignSignatoryFetchFiles(Request $request)
    {
        $paginate = $request->page_count ? intval($request->page_count) : ENV('DEFAULT_PAGECOUNT');
        return SF::where('name', 'LIKE', '%' . $request->keyword . '%')
            ->whereHas('versions', function ($query) {
                $query->whereHas('fileSignatory', function ($query) {
                    $query->where('user_id', Auth::id())
                        ->orWhereHas('signee', function ($query) {
                            $query->where('user_id', Auth::id());
                        });
                });
            })
            ->without('modifier', 'extraFields', 'access', 'documentType')->paginate($paginate);
    }
}
