<?php

namespace Suiterus\Dms\Controllers\Repositories;

use App\Enums\Dms\DriveType;
use Illuminate\Database\Eloquent\ModelNotFoundException as ME;
use Suiterus\Dms\Models\Repositories\SectionAccess;
use Suiterus\Dms\Models\Repositories\Section;
use Illuminate\Support\Collection;
use App\Http\Controllers\Controller;
use Spatie\Permission\Models\Role;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\Storage;
use Suiterus\Dms\Models\Files\File as SF;
use Suiterus\Dms\Models\Files\FileField as SFF;
use Illuminate\Http\Request;
use Validator;
use Exception;
use Auth;
use DB;
use Suiterus\Dms\Services\Repositories\PersonalFolderService;

class PersonalFolderController extends FolderController
{

    public function search_folder(Request $req)
    {
        $data = $this->searchFolder($req, new PersonalFolderService);
        return response()->json([
            'data' => $data
        ]);
    }

    public function list_root_folder(Request $req)
    {
        $data = $this->listRootFolder($req, new PersonalFolderService);
        return response()->json([
            'data' => $data
        ]);
    }

    public function search_file(Request $req)
    {

        $data = $this->searchFile($req, new PersonalFolderService);

        return response()->json([
            'data'  => $data
        ]);
    }

    // Fetch file which has been uploaded in dashboard
    public function root_search_file(Request $req)
    {
        $paginate = $req->page_count ? intval($req->page_count) : ENV('DEFAULT_PAGECOUNT');

        $data = SF::where([['name', 'LIKE', '%' . $req->keyword . '%'], ['section_id', 0], ['type', 3]])
            ->whereHas('access', function (Builder $query) {
                $query->where('user_id', Auth::user()->id);
            })->orderBy('name', 'asc')->paginate($paginate);

        return response()->json([
            'data'  => $data
        ]);
    }

    // Fetch list of sections to which folders/files can be moved/copied.
    public function list_folders(Request $req)
    {
        $data = $this->movableFolderList($req->folders, new DriveType, $req->id ?? 0, new PersonalFolderService);

        return response()->json([
            'data' => $data
        ]);
    }
}
