<?php

namespace Suiterus\Dms\Controllers;

use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth; 
use Suiterus\Dms\Models\NotificationMessages;
use Illuminate\Support\Facades\Validator;

class NotificationMessagesController extends Controller
{
    public function create_notification_messages(Request $req){
        $valid = Validator::make($req->all(),[
            'notification_messages' => 'required|array',
        ]);
        if($valid->fails()){
            return response()->json([
                'errors'    =>  $valid->errors()
            ],400);
        }
        DB::beginTransaction();
        try {
            foreach($req->notification_messages as $notification_message){
               NotificationMessages::updateOrCreate(
                    [
                        ['id', $notification_message['id']],
                    ],
                    [
                        'header' => $notification_message['header'],
                        'sender_message' => $notification_message['sender_message'],
                        'receiver_message' => $notification_message['receiver_message'],
                        'created_by' => Auth::id(),
                    ]);
            }
           
            DB::commit();
            return response()->json([
                'text'  => 'Notification Message has been created/updated successfully.'
            ]);
        } catch (Exception $e) {
            DB::rollback();
            return response()->json([
                'errors'    =>  [ 'Can`t create your entry as of now. Contact the developer to fix it. Error Code : NM-comp-0x01' ],
                'msg'   =>  $e->getMessage()
            ],500);
        }
    }

    public function fetch_notification_messages(){
        return NotificationMessages::get();
    }
}
