<?php

namespace Suiterus\Dms\Controllers\LevelOfApprover;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Exception;
use Illuminate\Support\Facades\Validator;
use Suiterus\Dms\Models\LevelOfApprover\LevelOfApprover;

class LevelOfApproverController extends Controller
{
    public function create(Request $request)
    {
        $valid = Validator::make($request->all(), [
            'name'  =>  'required'
        ]);
        if ($valid->fails()) {
            return response()->json([
                'errors'    =>  $valid->errors()
            ], 400);
        }
        DB::beginTransaction();

        try {
            LevelOfApprover::create([
                'name' => $request->name,
                'is_default' => $request->is_default ?? false
            ]);
            DB::commit();
            return response()->json([
                'text'  =>  'Level of approver has been created.'
            ]);
        } catch (Exception $e) {
            DB::rollback();
            return response()->json([
                'errors'    =>  ['There is a problem in creating a new Level of Approver.'],
                'msg'       =>  $e->getMessage()
            ], 500);
        }
    }

    public function paginate(Request $request)
    {
        $paginate = $request->page_count ? intval($request->page_count) : env('DEFAULT_PAGECOUNT');
        return LevelOfApprover::withTrashed()->paginate($paginate);
    }

    public function fetch()
    {
        return LevelOfApprover::get();
    }

    public function delete(Request $request)
    {
        $valid = Validator::make($request->all(), [
            'id'  =>  'required|exists:' . env('DMS_DB_CONNECTION') . '.level_of_approvers,id'
        ]);
        if ($valid->fails()) {
            return response()->json([
                'errors'    =>  $valid->errors()
            ], 400);
        }
        DB::beginTransaction();

        try {
            LevelOfApprover::where('id', $request->id)->delete();
            DB::commit();
            return response()->json([
                'text'  =>  'Deleted.'
            ]);
        } catch (Exception $e) {
            DB::rollback();
            return response()->json([
                'errors'    =>  ['There is a problem in deleting this level of approver.'],
                'msg'       =>  $e->getMessage()
            ], 500);
        }
    }

    public function restoreDelete(Request $request)
    {
        $valid = Validator::make($request->all(), [
            'id'  =>  'required|exists:' . env('DMS_DB_CONNECTION') . '.level_of_approvers,id'
        ]);
        if ($valid->fails()) {
            return response()->json([
                'errors'    =>  $valid->errors()
            ], 400);
        }
        DB::beginTransaction();

        try {
            LevelOfApprover::where('id', $request->id)->restore();
            DB::commit();
            return response()->json([
                'text'  =>  'Restored.'
            ]);
        } catch (Exception $e) {
            DB::rollback();
            return response()->json([
                'errors'    =>  ['There is a problem in restoring this level of approver.'],
                'msg'       =>  $e->getMessage()
            ], 500);
        }
    }
}
