<?php

namespace Suiterus\Dms\Controllers\LevelOfApprover;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Exception;
use Illuminate\Support\Facades\Validator;
use Suiterus\Dms\Models\LevelOfApprover\DocumentTypeApprovalTemplate;

class DocumentTypeApprovalTemplateController extends Controller
{
    public function create(Request $request)
    {
        $valid = Validator::make($request->all(), [
            'template'  =>  'required'
        ]);
        if ($valid->fails()) {
            return response()->json([
                'errors'    =>  $valid->errors()
            ], 400);
        }
        DB::beginTransaction();

        try {

            DocumentTypeApprovalTemplate::updateOrCreate(
                ['document_type_id' => $request->document_type_id],
                [
                    'document_type_id' => $request->document_type_id,
                    'template' => json_encode($request->template)
                ]
            );

            DB::commit();
            return response()->json([
                'text'  =>  'Template has been created.'
            ]);
        } catch (Exception $e) {
            DB::rollback();
            return response()->json([
                'errors'    =>  ['There is a problem in creating new Template.'],
                'msg'       =>  $e->getMessage()
            ], 500);
        }
    }

    public function fetch(Request $request)
    {
        $template = DocumentTypeApprovalTemplate::where('document_type_id', $request->document_type_id)->first();

        if (!isset($template->template)) {
            return response()->json([
                'message' => 'No template.'
            ], 400);
        }

        $template->template = json_decode($template['template']);

        return $template;
    }
}
