<?php

namespace Suiterus\Dms\Controllers;

use Activity;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Traits\Logs\HasCustomLogs;
use Illuminate\Support\Facades\Auth;


class GlobalSearchController extends Controller
{

    use HasCustomLogs;

    public function searchFile(Request $request)
    {
        if ($request->search_text) {
            $this->logCustomMessage(
                'global_search',
                null,
                Auth::user()->name . ' searched for "' . $request->search_text . '"',
                null,
                'Search',
                new Activity()
            );
        }

        try {
            return DB::connection(env('DMS_DB_CONNECTION'))->select('SELECT DISTINCT files.id, files.name, files.type, files.updated_at, custom_form_values.form_value FROM files INNER JOIN file_versions ON files.id = file_versions.file_id INNER JOIN file_accesses ON files.id = file_accesses.file_id LEFT JOIN custom_form_values ON file_versions.id = custom_form_values.file_version_id WHERE files.deleted_at IS NULL AND (((LOWER(files.name) LIKE "%' . strtolower($request->search_text) . '%" OR LOWER(JSON_EXTRACT(form_value, "$**.value")) LIKE "%' . strtolower($request->search_text) . '%") AND file_accesses.user_id = "' . Auth::id() . '") OR ((LOWER(files.name) LIKE "%' . strtolower($request->search_text) . '%" OR LOWER(JSON_EXTRACT(form_value, "$**.value")) LIKE "%' . strtolower($request->search_text) . '%") AND files.type = 2)) ORDER BY files.updated_at LIMIT 4;');
        } catch (Exception $e) {
            return response()->json([
                'message' => $e->getMessage()
            ], 500);
        }
    }

    public function searchFolder(Request $request)
    {
        try {
            return DB::connection(env('DMS_DB_CONNECTION'))->select('SELECT DISTINCT sections.id, sections.name, sections.type, sections.description FROM sections LEFT JOIN section_accesses ON sections.id = section_accesses.section_id WHERE (LOWER(sections.name) LIKE "%' . strtolower($request->search_text) . '%" OR LOWER(sections.description) LIKE "%' . strtolower($request->search_text) . '%") AND (section_accesses.user_id = "' . Auth::id() . '" OR sections.type = 2) LIMIT 4;');
        } catch (Exception $e) {
            return response()->json([
                'message' => $e->getMessage()
            ], 500);
        }
    }
}
